var VendorWifiTests=(function VendorWifiTests(){var a=null;var i={};var d=2000;module("VendorWifi",{setup:function(){VendorWifi.SetWifiCallbackDestination(i);a={}},teardown:function(){i.parameterError=i.changedLoginStatus=i.receivedNonSpecificError=i.setBatteryStatus=i.setConnectedDevices=i.setWifiStatus=$.noop;VendorWifi=vendorWifi()}});test("Synchronous Login fail",function(){var k=VendorWifi.Login({password:"NotAdmin"});ok(Util.isErrorObject(k),"Result is error");equals(k.errorType,"badPassword")});test("Synchronous Login success",function(){var k=VendorWifi.Login({password:"admin"});ok(k);ok(!Util.isErrorObject(k),"Not error")});test("Synchronous logout",function(){var k=VendorWifi.Logout(null);ok(k)});test("Sequence: Login, Logout and LoginStatus",function(){var l=VendorWifi.LoginStatus();equals(l.status,"loggedOut");var k=VendorWifi.Login({password:"admin"});equals(typeof k,"object");l=VendorWifi.LoginStatus();equals(l.status,"loggedIn");var m=VendorWifi.Logout();equals(typeof m,"object");l=VendorWifi.LoginStatus();equals(l.status,"loggedOut")});test("Get/Set GuestUserControl",function(){var l=VendorWifi.GetGuestUserControl();validateObject(l,{allowedToConnect:isBoolean,allowedToAccessSettings:isBoolean},"initial GetGuestUserControl");var k=VendorWifi.SetGuestUserControl({allowedToConnect:true,allowedToAccessSettings:false});ok(k,"SetGuestUserControl");l=VendorWifi.GetGuestUserControl();validateObject(l,{allowedToConnect:true,allowedToAccessSettings:false},"GetGuestUserControl after setting")});test("GetSdCardName",function(){var k=VendorWifi.GetSdCardName();validateObject(k,{sdCardName:isString},"GetSdCardName");equals(k.sdCardName,"MicroSD Card","GetSdCardName")});test("Get/Set WifiSettings",function(){var l=VendorWifi.GetWifiSettings();validateObject(l,{wifiEnabled:isBoolean,broadcastSsidEnabled:isBoolean,selectedChannel:makeEnumerationChecker("0","1","2","3","4","5","6","7","8","9","10","11","12","13","14"),supportedModes:isArrayOfStrings,wifiMode:makeEnumerationChecker(l.supportedModes),ssid:isString},"initial GetWifiSettings");var m={wifiEnabled:true,broadcastSsidEnabled:true,selectedChannel:"2",wifiMode:"b/g",ssid:"Testing SSID"};var k=VendorWifi.SetWifiSettings(m);ok(k,"SetWifiSettings");l=VendorWifi.GetWifiSettings();$.extend(m,{supportedModes:isArrayOfStrings});validateObject(l,m)});test("Get/Set MacSettings",function(){var l=VendorWifi.GetMacSettings();validateObject(l,{macFilteringEnabled:isBoolean,macFilteringMode:makeEnumerationChecker("whitelist","blacklist"),authorizedDevices:makeObjectArrayValidator({macAddress:isMacAddressString,name:isString,description:isString,connectionType:makeEnumerationChecker("allowed","disallowed")},"authorizedDevices")},"initial GetMacSettings");var m={macFilteringEnabled:true,macFilteringMode:"blacklist",authorizedDevices:[{macAddress:"01:01:01:01:01:01",name:"Fred",description:"Fred's PC",connectionType:"allowed"},{macAddress:"02:01:01:01:01:01",name:"Jim",description:"Jim's PC",connectionType:"allowed"},{macAddress:"04:01:01:01:01:01",name:"New",description:"New PC",connectionType:"disallowed"}]};var k=VendorWifi.SetMacSettings(m);ok(k,"SetMacSettings");l=VendorWifi.GetMacSettings();validateObject(l,m)});test("Get/Set WifiSecuritySettings - object work",function(){var l=VendorWifi.GetWifiSecuritySettings();validateObject(l,{encryptionKey:"",authenticationMode:makeEnumerationChecker(Util.collect(l.validAuthenticationModes,function(n){return n.authenticationMode})),validAuthenticationModes:makeObjectArrayValidator({authenticationMode:isFullString,validEncryptionTypes:makeValidEncryptionTypesChecker()},"list of wifi authentication modes"),encryptionType:isFullString},"initial GetWifiSecuritySettings");var m={authenticationMode:"AUTO",encryptionKey:"0123456789",encryptionType:"WEP"};var k=VendorWifi.SetWifiSecuritySettings(m);ok(k,"SetWifiSecuritySettings");l=VendorWifi.GetWifiSecuritySettings();validateObject(l,{encryptionKey:"",authenticationMode:"AUTO",validAuthenticationModes:makeObjectArrayValidator({authenticationMode:isFullString,validEncryptionTypes:makeValidEncryptionTypesChecker()},"list of wifi authentication modes"),encryptionType:"WEP"},"initial GetWifiSecuritySettings")});test("Get/Set WifiSecuritySettings - integrity of object",function(){var m=VendorWifi.GetWifiSecuritySettings();var n=Util.collect(m.validAuthenticationModes,function(p){return p.authenticationMode});var l=$.grep(m.validAuthenticationModes,function(p){return p.authenticationMode===m.authenticationMode});l=$(l).get(0);if(l===undefined){l=[]}validateObject(m,{encryptionKey:"",validAuthenticationModes:isArrayofObjects,authenticationMode:makeEnumerationChecker(n),encryptionType:makeEnumerationChecker(l.validEncryptionTypes)},"initial GetWifiSecuritySettings");var o={encryptionKey:"0123456789",authenticationMode:"Auto",encryptionType:"WEP"};var k=VendorWifi.SetWifiSecuritySettings(o);ok(k,"SetWifiSecuritySettings");m=VendorWifi.GetWifiSecuritySettings();validateObject(m,{encryptionKey:"",validAuthenticationModes:isArrayofObjects,authenticationMode:"Auto",encryptionType:"WEP"},"initial GetWifiSecuritySettings")});test("GetMobileWifiDiagnostics",function(){var k=VendorWifi.GetMobileWifiDiagnostics();validateObject(k,{productName:isFullString,softwareVersion:isFullString,modemVersion:isFullString,routerVersion:isFullString,hardwareVersion:isFullString,serialNumber:isFullString,simSerialNumber:isFullString,simMsisdn:isFullString,deviceImei:isFullString,simImsi:isFullString,simStatus:makeEnumerationChecker("index","sim-error","pin-required","puk-lock","puk-required"),sdCardAvailable:isBoolean,sdCardTotalMemory:isIntegerString,sdCardAvailableMemory:isIntegerString,currentConnectedUsers:isIntegerString,maxConnectedUsers:isIntegerString,timeSinceStartup:isIntegerString},"GetMobileWifiDiagnostics");equals(k.maxConnectedUsers,"5","Expect maxConnectedUsers to be 5")});test("GetRouterDiagnostics",function(){var k=VendorWifi.GetRouterDiagnostics();validateObject(k,{dhcpEnabled:isBoolean,dmzEnabled:isBoolean},"GetRouterDiagnostics")});test("GetCurrentlyAttachedDevices",function(){var k=VendorWifi.GetCurrentlyAttachedDevices();validateObject(k,{attachedDevices:makeObjectArrayValidator({ipAddress:isIpAddressString,hostName:isFullString,macAddress:isMacAddressString,timeConnected:isIntegerString},"attachedDevices")},"GetCurrentlyAttachedDevices")});test("GetSdMemorySizes",function(){var k=VendorWifi.GetSdMemorySizes();validateObject(k,{totalMemorySize:isIntegerString,availableMemorySize:isIntegerString},"GetSdMemorySizes")});function c(k){ok(k);validateObject(k,{files:makeObjectArrayValidator({name:isFullString,lastUpdated:isFullString,size:isIntegerOrNullString,type:makeEnumerationChecker("file","folder"),fileUrlOrFolderPath:isFullString},"files")},"GetFileList")}test("GetFileList",function(){var k=VendorWifi.GetFileList({folderPath:""});c(k)});function f(l,m){m=m||"";var k=VendorWifi.GetFileList({folderPath:m});c(k);return $.grep(k.files,function(o,n){return o.name===l})}test("Delete, Create, list folder",function(){var m="fred";VendorWifi.DeleteFilesAndFolders({folderPath:"",files:[{name:m}]});var l=VendorWifi.CreateFolder({folderPath:"",folderName:m});ok(l);var k=f(m);equals(k.length,1,"Found "+m+" in root directory");fileList=f(k[0].fileUrlOrFolderPath);equals(fileList.length,0,"Expect no files in new directory");l=VendorWifi.DeleteFilesAndFolders({folderPath:"",files:[{name:m}]});ok(l);k=f(m);equals(k.length,0,m+" should be deleted")});test("Upload and delete file",function(){var m="Uploaded File.txt";var n="c:\\somewhere\\";VendorWifi.DeleteFilesAndFolders({folderPath:"",files:[{name:m}]});var l=f(m);equals(l.length,0,"Expected no "+m+" in root directory");var k=VendorWifi.CheckFileExists({destinationFolderOnDevice:"",sourcePathOnLocalMachine:n+m});ok($.isEmptyObject(k));l=f(m);equals(l.length,1,"Expected "+m+" in root directory");k=VendorWifi.DeleteFilesAndFolders({folderPath:"",files:[{name:m}]});ok(k);l=f(m);equals(l.length,0,m+" should be deleted")});test("Get/Set SdCardSharing",function(){var l=VendorWifi.GetSdCardSharing();validateObject(l,{access:makeEnumerationChecker("none","readOnly","readWrite"),sharedFolder:isString,sdCardStatus:isBoolean},"initial GetSdCardSharing");var m={access:"readOnly",sharedFolder:"documents",sdCardStatus:true};var k=VendorWifi.SetSdCardSharing(m);ok(k,"SetSdCardSharing");l=VendorWifi.GetSdCardSharing();validateObject(l,m)});test("Get/Set RouterIpConfiguration",function(){var l=VendorWifi.GetRouterIpConfiguration();validateObject(l,{ipAddress:isIpAddressString,subnetMask:isSubnetMaskString,lanDomain:isFullString,switchBatteryOffWhenIdle:isBoolean},"initial GetRouterIpConfiguration");var m={ipAddress:"192.168.0.1",subnetMask:"255.255.255.0",lanDomain:"VodafoneMobile.wifi",switchBatteryOffWhenIdle:true};var k=VendorWifi.SetRouterIpConfiguration(m);ok(k,"SetRouterIpConfiguration");l=VendorWifi.GetRouterIpConfiguration();validateObject(l,m)});test("Get/Set RouterDhcpConfiguration",function(){var l=VendorWifi.GetRouterDhcpConfiguration();validateObject(l,{dhcpEnabled:isBoolean,dhcpRangeStart:isIpAddressString,dhcpRangeEnd:isIpAddressString,dhcpLeaseTime:isIntegerString},"initial GetRouterDhcpConfiguration");var m={dhcpEnabled:true,dhcpRangeStart:"192.168.0.50",dhcpRangeEnd:"192.168.0.100",dhcpLeaseTime:"86400"};var k=VendorWifi.SetRouterDhcpConfiguration(m);ok(k,"SetRouterDhcpConfiguration");l=VendorWifi.GetRouterDhcpConfiguration();validateObject(l,m)});test("Synchronous Change Password",function(){var k=VendorWifi.ChangePassword({oldPassword:"admin",newPassword:"admin2"});ok(!Util.isErrorObject(k),"Password change OK");k=VendorWifi.ChangePassword({oldPassword:"admin",newPassword:"admin2"});ok(Util.isErrorObject(k),"Password change fails if old password wrong");equals(k.errorType,"badPassword");k=VendorWifi.ChangePassword({oldPassword:"admin2",newPassword:"admin"});ok(!Util.isErrorObject(k),"Password change back OK")});test("Get/Set NatSettings",function(){var l=VendorWifi.GetNatSettings();validateObject(l,{natEnabled:isBoolean,natType:makeEnumerationChecker("symmetric","cone")},"initial GetNatSettings");var m={natEnabled:true,natType:"cone"};var k=VendorWifi.SetNatSettings(m);ok(k,"SetNatSettings");l=VendorWifi.GetNatSettings();validateObject(l,m)});test("Get/Set ApplicationPortMappings",function(){var l=VendorWifi.GetApplicationPortMappings();ok(l);validateObject(l,{enabled:isBoolean,portMappings:makeObjectArrayValidator({applicationName:isFullString,applicationProtocol:makeEnumerationChecker("udp","tcp"),sourcePort:isString,destinationIp:isIpAddressString,destinationPort:isIntegerString})},"GetApplicationPortMappings");var m={enabled:true,portMappings:[{applicationName:"app1",applicationProtocol:"udp",sourcePort:"80",destinationIp:"192.127.0.1",destinationPort:"13"},{applicationName:"app2",applicationProtocol:"tcp",sourcePort:"8080",destinationIp:"192.127.0.3",destinationPort:"56"},{applicationName:"app3",applicationProtocol:"tcp",sourcePort:"978",destinationIp:"192.127.0.6",destinationPort:"678"}]};var k=VendorWifi.SetApplicationPortMappings(m);ok(k,"SetApplicationPortMappings");l=VendorWifi.GetApplicationPortMappings();validateObject(l,m)});test("Get/Set DmzSettings",function(){var l=VendorWifi.GetDmzSettings();validateObject(l,{dmzEnabled:isBoolean,dmzIpAddress:isIpAddressString},"initial GetDmzSettings");var m={dmzEnabled:true,dmzIpAddress:"192.127.0.1"};var k=VendorWifi.SetDmzSettings(m);ok(k,"SetDmzSettings");l=VendorWifi.GetDmzSettings();validateObject(l,m)});test("GetRouterBackupUrl",function(){var k=VendorWifi.GetRouterBackupUrl();validateObject(k,{backupUrl:isString},"GetRouterBackupUrl")});test("Get/Set IdleTime",function(){VendorWifi.SetIdleTime({value:"300"});var k=VendorWifi.GetIdleTime();ok(k);equals(k.value,"300")});test("Get/Set WebUiData",function(){var l=VendorWifi.GetWebUiData();$.each(l,function(n,o){equals(typeof o,"string","Checking: "+n)});var m={pinValue:"1234"};var k=VendorWifi.SetWebUiData(m);ok(!Util.isErrorObject(k),"SetWebUiData");l=VendorWifi.GetWebUiData();validateObject(l,m)});test("GetVodafoneConfiguration",function(){var k=VendorWifi.GetVodafoneConfiguration();validateObject(k,{sku:makeEnumerationChecker("Enterprise None P&P","Vodafone Pocket WiFi","Vodafone Mobile Wi-Fi"),maxConnectedDevices:isIntegerString},"GetRouterBackupUrl")});test("GetParameterValidation values",function(){var k=VendorWifi.GetParameterValidation();$.each(["maxPassword","maxSsid","maxWifiChannel","maxPortMappingApplicationName","maxMacSettingsDescription"],function(l,m){ok(typeof k[m]==="number","validation value: "+m)})});test("GetParameterValidation functions",function(){var k=VendorWifi.GetParameterValidation();ok(k.validatePassword("a"));ok(!k.validatePassword("%"));ok(k.validateSsid("0"));ok(!k.validateSsid("%"));ok(k.validateFolderName("a b"));ok(!k.validateFolderName("/"));ok(k.validateEncryptionKey("deadbeef00","WEP"));ok(!k.validateEncryptionKey("alkjf","WEP "));ok(k.validateIpAddress("127.0.0.1"));ok(!k.validateIpAddress("1.1.1"));ok(k.validateSubnetMask("255.255.255.0"));ok(!k.validateSubnetMask("255.255.255.9"));ok(!k.validateSubnetMask("255.255.0"));ok(k.validatePort("440"));equals(k.validatePort("686868686"),false,"Port numbers must be less than 65536: 686868686");equals(k.validatePort("0"),false,"Port numbers must be more than 0: 0");equals(k.validatePort("PETE"),false,"Alpha port numbers are not valid: PETE");equals(k.validatePort("pete10"),false,"Alphanumeric port numbers are not valid: pete10");equals(k.validatePort("10pete"),false,"Alphanumeric port numbers are not valid: 10pete");ok(k.validateMacAddress("01:01:01:01:01:01"));ok(!k.validateMacAddress("Q:01:01:01:01:01"))});test("Each call answers a different object (see Ownership in the spec)",function(){var l=VendorWifi.GetDmzSettings();var k=VendorWifi.GetDmzSettings();ok(l!==k)});asyncTest("Each async call answers a different object (see Ownership)",function(){expect(1);var k;VendorWifi.GetDmzSettings(null,function(l){k=l});VendorWifi.GetDmzSettings(null,function(l){ok(l!==k);start()})});asyncTest("Login fail sends back sensible error object",function(){expect(4);VendorWifi.Login({password:"somethingElse"},$.noop,function k(l){ok(Util.isErrorObject(l),"got error object");equals(l.errorType,"badPassword");equals(typeof l.errorId,"string");equals(typeof l.errorText,"string");start()})});asyncTest("Login success",function(){var l=false;expect(2);VendorWifi.Login({password:"admin"},function k(n){l=true;ok(n);start()},function m(n){ok(false,"Unexpected login failure");start()});ok(!l,"Callback must happen after Login returns")});asyncTest("Login parameter error",function(){expect(1);i.parameterError=function(){ok(true);start()};VendorWifi.Login({},$.noop)});asyncTest("Logout success",function(){expect(1);VendorWifi.Logout(null,function k(l){ok(l);start()})});asyncTest("CheckUploadFileStatus - file upload success",function(){var k=false;expect(2);VendorWifi.CheckUploadFileStatus({},function l(n){k=true;ok(n);start()},function m(n){ok(false,"Unexpected CheckUploadFileStatus failure");start()});ok(!k,"Callback must happen after CheckUploadFileStatus returns")});asyncTest("CheckUploadFileStatus - file upload failure",function(){var k=false;expect(5);VendorWifi.CheckUploadFileStatus({isErrorTest:true},function l(n){k=true;ok(false,"Unexpected CheckUploadFileStatus success");start()},function m(n){ok(Util.isErrorObject(n),"got error object");equals(n.errorType,"noSdCardPresent");equals(typeof n.errorId,"string");equals(typeof n.errorText,"string");start()});ok(!k,"Callback must happen after CheckUploadFileStatus returns")});var j,e,h;function g(){j=e=h=null;i.setBatteryStatus=function(k){j=k};i.setWifiStatus=function(k){e=k};i.setConnectedDevices=function(k){h=k}}function b(){var k;ok(j,"batteryStatus");checkMatches(/^(charging|use)$/,j.batteryStatus,"batteryStatus");checkMatches(/^\d{1,3}$/,j.batteryLevel,"batteryLevel");checkMatches(/^\d+$/,j.batteryTime,"batteryTime");ok(e,"wifiStatus");checkMatches(/^(enabled|disabled)$/,e.wifiStatus,"wifiStatus");checkMatches(/^.*$/,e.ssid,"ssid");checkMatches(/^(|NONE|WEP|AES|TKIP|[A-Z\/.]+)$/,e.security,"security");ok(h,"connectedDevices");ok($.isArray(h.devices),"Device list is array");for(k=0;k<4;k++){if(k<h.devices.length){equals(typeof h.devices[k].deviceName,"string","Must have device name: "+k)}else{ok(true)}}}asyncTest("Expect all the callbacks with sensible values",function(){expect(14);g();VendorWifi.ForceCallbacks();setTimeout(function(){b();start()},d)});return{setCallbacks:g,validateCallbackObjects:b,CallbackDestination:i}}());