# =====================
#   循环开始
# =====================

while ($true) {

    # 获取当前日期，用来生成每日独立日志
    $date = Get-Date -Format "yyyy-MM-dd"
    $logDir = "C:\Intel\Logs"
    $logPath = "$logDir\ProcessConnections-$date.csv"

    # 如果日志目录不存在则创建
    if (!(Test-Path $logDir)) {
        New-Item -ItemType Directory -Path $logDir -Force | Out-Null
    }

    # 如果日志文件不存在，写入表头
    if (!(Test-Path $logPath)) {
        "Time,ProcessName,ProcId,ExePath,Protocol,LocalAddress,LocalPort,RemoteAddress,RemotePort,State" |
            Out-File -FilePath $logPath -Encoding utf8
    }

    # 当前时间
    $now = Get-Date -Format "yyyy-MM-dd HH:mm:ss"

    # 获取当前 TCP 连接
    $tcpConns = Get-NetTCPConnection -State Established -ErrorAction SilentlyContinue

    foreach ($conn in $tcpConns) {

        $procId = $conn.OwningProcess
        $proc = Get-Process -Id $procId -ErrorAction SilentlyContinue

        if ($proc) {
            $exePath = ""
            try {
                $exePath = $proc.MainModule.FileName
            } catch {
                $exePath = ""
            }

            $line = ('"{0}","{1}","{2}","{3}","{4}","{5}","{6}","{7}","{8}","{9}"' -f `
                $now,
                $proc.ProcessName,
                $procId,
                $exePath,
                "TCP",
                $conn.LocalAddress,
                $conn.LocalPort,
                $conn.RemoteAddress,
                $conn.RemotePort,
                $conn.State
            )

            Add-Content -Path $logPath -Value $line
        }
    }

    # 每 5 秒执行一次
    Start-Sleep -Seconds 5
}
